-- Messaging for Offer Letter Expires Event (warner Sprint)

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'Offer Letter Expires');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='Offer Letter Expires');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'OFFER_LETTER_EXPIRES', 'Offer Letter Expires', 'SYSTEM_SCHEDULE', 0, 0, 1, 0, 1, 0, 0, 'Offer Letter Expires','Offer Letter Expires');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'OFFER_LETTER_EXPIRES_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'OFFER_LETTER_EXPIRES_RECIPIENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='OFFER_LETTER_EXPIRES_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'OFFER_LETTER_EXPIRES_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='OFFER_LETTER_EXPIRES_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='OFFER_LETTER_EXPIRES_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='OFFER_LETTER_EXPIRES_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId, "SELECT 
    T1.id AS USER_ID
FROM
    application_program T1
WHERE
    DATE_FORMAT((DATE(NOW()) - INTERVAL 1 DAY),'%Y-%m-%d')= DATE_FORMAT(T1.offerLetterDueDate ,'%Y-%m-%d')",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='OFFER_LETTER_EXPIRES_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T7.`id` AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`middleName` AS MIDDLE_NAME,      
    T4.`lastName` AS LAST_NAME,    
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    T3.`code` AS APPLICATION_CODE,
    T8.`displayName` AS ACADEMY_NAME_LOCATION,
    T8.`academyName` AS ACADEMY_NAME,
    T8.`locationName` AS LOCATION_NAME,
    T12.`programNameToBePrint` AS PROGRAM_NAME,
    T10.`printName` AS BATCH_PRINT_NAME,
    T18.`seatName` AS SEAT_TYPE,
    CONCAT(T23.phoneCountryCode,'-',T23.phoneAreaCode,'-',T23.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T23.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T23.websiteURL AS ACADEMY_LOCATION_URL,
    (Case 
        when 
            T24.offerType = 'FIRM'
        then 
            'Firm'
	when 
            T24.offerType = 'PROVISIONAL'
        then 
            'Provisional'
        else '' 
    end) as FIRM_OR_PROVISIONAL,
    (CASE
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
            WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ESCALATED'
        THEN
            'Escalated'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ESCALATED_OFFER_REVIEWED'
        THEN
            'Escalated Offer Reviewed'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'WAITING_LIST'
        THEN
            'Waiting List'  
        ELSE ''
    END) AS OFFER_STATUS,
    DATE_FORMAT(T3.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL,
    T8.id as ACADEMY_LOCATION_ID,
    T8.academyId as ACADEMY_ID
FROM
    application T3
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId        
        LEFT OUTER JOIN
    prog_batch_seat_config T9 on T9.id = T7.progBatchSeatConfigId
        LEFT OUTER JOIN
    batches T10 on T10.id = T9.programBatchId
        LEFT OUTER JOIN
    programs T12 ON T12.id = T7.programId        
        LEFT JOIN
    seat_types T18 on T18.id = T9.seatTypeId
        LEFT JOIN
    academy_location_addresses T22 ON T22.academyLocationId = T8.id
        LEFT JOIN
    address T23 ON T23.id = T22.addressId AND T23.addressTypeId = 10
        LEFT JOIN
    app_program_adm_details T24 on T24.applicationProgramId = T7.id        
        LEFT OUTER JOIN    
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T7.id IN (namedParams) and T7.currentStatus = (Case 
        when 
            T7.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        then 
            'PROVISIONAL_OFFER_EXPIRED'
	    when 
            T7.currentStatus = 'OFFER_EXPIRED'
        then 
            'OFFER_EXPIRED'
        else '' 
    end)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchPrintName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "seatType",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "applicationStatus",
            "resultKey": "APPLICATION_STATUS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "offerStatus",
            "resultKey": "OFFER_STATUS",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "applicationDate",
            "resultKey": "APPLICATION_DATE",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "academyLocationId",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 17
        },{
            "id": 19,
            "value": "offerType",
            "resultKey": "FIRM_OR_PROVISIONAL",
            "displayCode": "",
            "displayOrder": 18
        },{
            "id": 20,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 19
        },{
            "id": 21,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 20
        },

    ]
}');


SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='OFFER_LETTER_EXPIRES_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='OFFER_LETTER_EXPIRES');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='Offer Letter Expires');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='OFFER_LETTER_EXPIRES_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Buzz Offer Letter Expires',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Buzz Offer Letter Expires',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','$recipientData[&quot;FIRM_OR_PROVISIONAL&quot;] OFFER EXPIRED','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">
            <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong></p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">
            Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Your acceptance of the  <strong>$recipientData[&quot;FIRM_OR_PROVISIONAL&quot;]</strong> Offer to study at The Independent Institute of Education&apos;s (The IIE&apos;s) $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;] has not yet been received. Regrettably, the <strong>$recipientData[&quot;FIRM_OR_PROVISIONAL&quot;]</strong> Offer has expired.
            </p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Please contact our student recruitment and admissions team on $recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;] or $recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;] if you have any queries..</p>
     
            </td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:12px;">
            <td style="padding:0px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Kind regards,<br/><br/><strong>The IIE&apos;s $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], The status pertaining to your studies at The IIE&apos;s $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;] has changed. please check your emails and action the next steps.
Please contact us if you have any queries.
Kind regards,
The IIE&apos;s $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;].');


set sql_safe_updates=0;
update msg_template_config set templatelanguageValue= 'English' where templatelanguageValue is null;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
set sql_safe_updates=1;

-- End Messaging for Offer Letter Expires Event 
